/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.VWParameterItem;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWParametersListCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_fieldIcon = null;
    private ImageIcon m_attachmentIcon = null;
    private ImageIcon m_wflGroupIcon = null;
    private ImageIcon m_xmlFieldIcon = null;
    private String m_readString = VWResource.s_accessModeIndicator.toString(VWResource.s_read);
    private String m_writeString = VWResource.s_accessModeIndicator.toString(VWResource.s_write);
    private String m_readWriteString = VWResource.s_accessModeIndicator.toString(VWResource.s_readWrite);

    public VWParametersListCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_fieldIcon = VWImageLoader.createImageIcon("field.gif");
            this.m_attachmentIcon = VWImageLoader.createImageIcon("attachment.gif");
            this.m_wflGroupIcon = VWImageLoader.createImageIcon("wflgroup.gif");
            this.m_xmlFieldIcon = VWImageLoader.createImageIcon("xml_field.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        try {
            if (value != null) {
                VWParameterItem paramItem = (VWParameterItem)value;
                VWFieldDefinition fieldDef = paramItem.getFieldDefinition();
                VWParameterDefinition paramDef = paramItem.getParameterDefinition();
                int nFieldType = paramDef == null ? fieldDef.getFieldType() : paramDef.getDataType();
                this.setFont(list.getFont());
                this.setEnabled(list.isEnabled());
                this.setIcon(null);
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                switch (nFieldType) {
                    case 32: {
                        this.setIcon(this.m_attachmentIcon);
                        break;
                    }
                    case 64: {
                        this.setIcon(this.m_wflGroupIcon);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 512: {
                        this.setIcon(this.m_fieldIcon);
                        break;
                    }
                    case 128: {
                        this.setIcon(this.m_xmlFieldIcon);
                    }
                }
                String paramStr = paramItem.getName();
                if (paramDef != null) {
                    switch (paramDef.getMode()) {
                        case 1: {
                            paramStr = paramStr + this.m_readString;
                            break;
                        }
                        case 2: {
                            paramStr = paramStr + this.m_writeString;
                            break;
                        }
                        case 3: {
                            paramStr = paramStr + this.m_readWriteString;
                        }
                    }
                }
                this.setText(paramStr);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

